<?php
/**
 * Complete Module
 *
 * @package     AutomatorWP\Integrations\WP_Courseware\Triggers\Complete_Module
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_Courseware_Complete_Module extends AutomatorWP_Integration_Trigger {

    public $integration = 'wp_courseware';
    public $trigger = 'wp_courseware_complete_module';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User completes a module', 'automatorwp-pro' ),
            'select_option'     => __( 'User completes <strong>a module</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User completes %1$s %2$s time(s)', 'automatorwp-pro' ), '{module}', '{times}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'User completes %1$s', 'automatorwp-pro' ), '{module}' ),
            'action'            => 'wpcw_user_completed_module',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'module' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'module',
                    'name'              => __( 'Module:', 'automatorwp-pro' ),
                    'option_none_value' => 'any',
                    'option_none_label' => __( 'any module', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_wpcw_get_modules',
                    'options_cb'        => 'automatorwp_wpcw_options_cb_module',
                    'default'           => 'any'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param integer $user_id
     * @param integer $unit_id
     * @param object $parent
     */
    public function listener( $user_id, $unit_id, $parent ) {

        $module_id = $parent->module_id;

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'module_id'   => $module_id,
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['module_id'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( $trigger_options['module'] != 'any' &&  absint( $trigger_options['module'] ) !== absint( $event['module_id'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_WP_Courseware_Complete_Module();